//+------------------------------------------------------------------+
//|                                             Damiani_Volt_mtf.mq4 |
//|                      Copyright  2009, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

#property copyright "rahman_DGBeta (_rdb_)"
#property link      "abdulrahman_maros@yahoo.com"

#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1 Red
#property indicator_width1 2
#property indicator_color2 Gold
#property indicator_width2 2 
#property indicator_color3 Lime
#property indicator_width3 2
#property indicator_color4 DeepSkyBlue
#property indicator_width4 2
#property indicator_color5 Tan
#property indicator_width5 1
//#property indicator_maximum 250
//#property indicator_minimum -190

//=================================================================================================
#property indicator_level1 100
//#property indicator_level2 85
#property indicator_level3 80

#property indicator_level4 50

#property indicator_level5 20
//#property indicator_level6 15
#property indicator_level7 0

#property indicator_levelcolor  SlateGray //C'160,160,160'   //DarkGray  
#property indicator_levelstyle STYLE_DOT
#property indicator_levelwidth 0
//=================================================================================================

extern int Vis_atr = 5;
extern int Vis_std = 8;
extern int Sed_atr = 20;
extern int Sed_std = 60;
extern double Threshold_level = 1.25;
extern bool lag_supressor = TRUE;
double Buff_X = 0.5;


extern int        TF                 = 30 ;    
bool              StepTimeFrame_Up   = false ;//true
extern bool       NoName             = false ;
extern bool       ShowDots           = false ;

extern int        LineSize           = 2;
extern int        DotSize            = 1;
extern int        CountBars          = 2000; 

double WPRBuffer1[];
double WPRBuffer2[];
double WPRBuffer3[];
double WPRBuffer4[];
double WPRBuffer5[];
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
int init()
  {
    IndicatorDigits(+2);
    SetIndexStyle (0, DRAW_LINE, STYLE_SOLID, LineSize);
    SetIndexBuffer(0, WPRBuffer1);
    
    SetIndexStyle (3, DRAW_LINE, STYLE_SOLID, LineSize);
    SetIndexBuffer(3, WPRBuffer2);
    SetIndexStyle (2, DRAW_LINE, STYLE_SOLID, LineSize);
    SetIndexBuffer(2, WPRBuffer3);
    SetIndexStyle (1, DRAW_LINE, STYLE_SOLID, LineSize);
    SetIndexBuffer(1, WPRBuffer4);
   
    SetIndexStyle (4, DRAW_ARROW, STYLE_SOLID,  DotSize);
    SetIndexArrow (4, 159);
    SetIndexBuffer(4, WPRBuffer5);
    
//========================================================================================    
      switch(TF)
   {  case 1 : string TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe";
      SetStepTimeFrame_Up();
   } }
   return(0); 
   
//==============================step timeframe up ========================================= 
   int deinit()                    
      { SetStepTimeFrame_Up(); }        
    return(0);        
//+---------------------------------------------------------------------------------------+
//+---------------------------------------------------------------------------------------+
int start()
  {  double   WPR_SHORT, WPR_LONG ;
     datetime TimeArray[];
     int    i,limit,y=0,counted_bars=IndicatorCounted();
     int    WPRShortPer=0,WPRLongPer=0;
     ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TF); 
   
    limit=Bars-counted_bars;
//==================================================================================================    
     SetIndexDrawBegin(0,Bars-CountBars);
     SetIndexDrawBegin(1,Bars-CountBars);
     SetIndexDrawBegin(2,Bars-CountBars);
     SetIndexDrawBegin(3,Bars-CountBars);
     SetIndexDrawBegin(4,Bars-CountBars);
     
    // repaint laaste 2 kerse met die lyn in    
  //  if(counted_bars>0) limit++; else if (limit>100) limit=CountBars;  
  

//====================================================================================================              
   for(i=0,y=0;i<limit;i++)
   {
   if (Time[i]<TimeArray[y]) y++;
//=========================================================================================

                    WPRBuffer1[i] =  iCustom(NULL, TF, "Damiani_Volt",Vis_atr,Vis_std,Sed_atr,Sed_std,Threshold_level,lag_supressor,Buff_X,0,y);
                                    
                    WPRBuffer2[i] =  iCustom(NULL, TF, "Damiani_Volt",Vis_atr,Vis_std,Sed_atr,Sed_std,Threshold_level,lag_supressor,Buff_X,2,y);
    
       
             if      (  ShowDots == true )
                     {  WPRBuffer5[i] = WPRBuffer2[i];  }  
//========== COLOR CODING ==================================================================               
       
       WPRBuffer4[i] = WPRBuffer2[i];
       WPRBuffer3[i] = WPRBuffer2[i];
       WPRBuffer2[i] = WPRBuffer2[i]; 
       
       if      (  WPRBuffer2[i] > WPRBuffer1[i] )
               {  WPRBuffer2[i] = EMPTY_VALUE;  }
               
       else if (  WPRBuffer2[i] < WPRBuffer1[i] ) 
               {  WPRBuffer3[i] = EMPTY_VALUE;  }
               
       else    {  WPRBuffer2[i] = EMPTY_VALUE;
                  WPRBuffer3[i] = EMPTY_VALUE;
               }
        
//==========================================================================================
   if  ( NoName == true  )
       {   string  ThisName = "(30M-SM)";
           string Text=ThisName;
            Text=Text+"("+TF;
            Text=Text+")";
           IndicatorShortName(Text); 
           SetIndexLabel(0,"1");
            SetIndexLabel(1,"2");
      }    
//====================================== 
if  ( NoName == false  )
{
        string  ThisName1 = "(30M-SM)";
        string Text1=ThisName1;
        Text1=Text1+"  ("+TF;
        Text1=Text1+")";
      //  Text1=Text1+"(";
      //  Text1=Text1+" "+DoubleToStr(WPR_Per_L,0);
      //  Text1=Text1+"/"+DoubleToStr(WPR_Per_S,0);
      //  Text1=Text1+")  ";
        IndicatorShortName(Text1); 
        SetIndexLabel(0,"(15M_SM)");
}       
//=========================================================================================       
  }    
   return(0);
  }
//==============================step timeframe up =========================================  
  void SetValues(int p1)        {   TF = p1;  }                                    
  void SetStepTimeFrame_Up()    {  if (StepTimeFrame_Up)                 
      {  switch (Period()  )                
      {  case PERIOD_M1  :  SetValues(PERIOD_M5);    break;       
         case PERIOD_M5  :  SetValues(PERIOD_M15);   break;         
         case PERIOD_M15 :  SetValues(PERIOD_M30);   break;     
         case PERIOD_M30 :  SetValues(PERIOD_H1);    break;            
         case PERIOD_H1  :  SetValues(PERIOD_H4);    break;               
         case PERIOD_H4  :  SetValues(PERIOD_D1);    break;                
         case PERIOD_D1  :  SetValues(PERIOD_W1);    break;                
         case PERIOD_W1  :  SetValues(PERIOD_MN1);   break;             
         case PERIOD_MN1 :  SetValues(PERIOD_MN1);   break;                   
   } } }    
//==================================================================================  